<?php
// ==== BOT CONFIG ====
$botToken = "6607784121:AAGWQ8StY70VTxGZHfhXgzzFZIVw6rk4H0U"; // Replace with your bot token
$apiURL = "https://api.telegram.org/bot$botToken/";

$channels = [
    "@botsworldtar", // Replace with first channel username
    "@cofincoin"  // Replace with second channel username
];

// ==== FUNCTIONS ====
function apiRequest($method, $data = []) {
    global $apiURL;
    $url = $apiURL . $method;
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    $res = curl_exec($ch);
    curl_close($ch);
    return json_decode($res, true);
}

function isMember($userId, $channel) {
    global $botToken;
    $url = "https://api.telegram.org/bot$botToken/getChatMember?chat_id=$channel&user_id=$userId";
    $res = json_decode(file_get_contents($url), true);
    if (isset($res["ok"]) && $res["ok"] == true) {
        $status = $res["result"]["status"];
        return in_array($status, ["member", "administrator", "creator"]);
    }
    return false;
}

function saveUser($userId) {
    $file = "users.txt";
    $users = file_exists($file) ? file($file, FILE_IGNORE_NEW_LINES) : [];
    if (!in_array($userId, $users)) {
        file_put_contents($file, $userId . PHP_EOL, FILE_APPEND);
    }
}

// ==== SPOTIFY API ====
function spotifySearch($query) {
    $url = "https://spotify-search.ma-coder-x.workers.dev/?q=" . urlencode($query);
    $res = json_decode(file_get_contents($url), true);
    return $res["status"] ? $res["result"] : [];
}

function spotifyDownload($trackUrl) {
    $url = "https://spotify-downloader.ma-coder-x.workers.dev/?url=" . urlencode($trackUrl);
    $res = json_decode(file_get_contents($url), true);
    return $res["status"] ? $res["result"] : null;
}

// ==== HANDLE UPDATES ====
$update = json_decode(file_get_contents("php://input"), true);

if (isset($update["message"])) {
    $chatId = $update["message"]["chat"]["id"];
    $userId = $update["message"]["from"]["id"];
    $text   = trim($update["message"]["text"]);

    if ($text == "/start") {
        $allJoined = true;
        foreach ($channels as $ch) {
            if (!isMember($userId, $ch)) {
                $allJoined = false;
            }
        }

        if (!$allJoined) {
            $buttons = [];
            foreach ($channels as $ch) {
                $buttons[] = [["text" => "Join $ch", "url" => "https://t.me/" . ltrim($ch, "@")]];
            }
            $buttons[] = [["text" => "✅ I Joined", "callback_data" => "check_join"]];

            apiRequest("sendMessage", [
                "chat_id" => $chatId,
                "text" => "🚨 You must join both channels to use this bot:",
                "reply_markup" => json_encode(["inline_keyboard" => $buttons])
            ]);
        } else {
            saveUser($userId);
            apiRequest("sendMessage", [
                "chat_id" => $chatId,
                "text" => "✅ Welcome! What do you want to do?",
                "reply_markup" => json_encode([
                    "inline_keyboard" => [
                        [["text" => "🔍 Search Song", "callback_data" => "search_song"]],
                        [["text" => "⬇️ Download from Link", "callback_data" => "download_link"]]
                    ]
                ])
            ]);
        }
    } elseif (strpos($text, "https://open.spotify.com/track/") === 0) {
        // Direct download from Spotify link
        $info = spotifyDownload($text);
        if ($info) {
            apiRequest("sendAudio", [
                "chat_id" => $chatId,
                "audio" => $info["download"],
                "title" => $info["title"],
                "performer" => $info["artist"],
                "thumb" => $info["image"],
                "caption" => "🎵 " . $info["title"] . "\n👤 " . $info["artist"]
            ]);
        } else {
            apiRequest("sendMessage", [
                "chat_id" => $chatId,
                "text" => "❌ Failed to get download link."
            ]);
        }
    } elseif ($text && $text != "/start") {
        // Handle Spotify Search by song name
        $results = spotifySearch($text);
        if (count($results) > 0) {
            $keyboard = [];
            $msg = "🎶 Results for: *$text*\n\n";
            foreach ($results as $i => $song) {
                $msg .= ($i+1) . ". *" . $song["title"] . "*\n👤 " . $song["artists"] . "\n\n";
                $keyboard[] = [
                    ["text" => "⬇️ " . $song["title"], "callback_data" => "dl|" . $song["link"]]
                ];
                if ($i >= 4) break; // Show only top 5
            }
            apiRequest("sendMessage", [
                "chat_id" => $chatId,
                "text" => $msg,
                "parse_mode" => "Markdown",
                "reply_markup" => json_encode(["inline_keyboard" => $keyboard])
            ]);
        } else {
            apiRequest("sendMessage", [
                "chat_id" => $chatId,
                "text" => "❌ No results found for: $text"
            ]);
        }
    }
}

// ==== HANDLE CALLBACKS ====
if (isset($update["callback_query"])) {
    $chatId = $update["callback_query"]["message"]["chat"]["id"];
    $userId = $update["callback_query"]["from"]["id"];
    $data   = $update["callback_query"]["data"];

    if ($data == "check_join") {
        $allJoined = true;
        foreach ($channels as $ch) {
            if (!isMember($userId, $ch)) {
                $allJoined = false;
            }
        }

        if ($allJoined) {
            saveUser($userId);
            apiRequest("sendMessage", [
                "chat_id" => $chatId,
                "text" => "🎉 Thank you for joining! What do you want to do?",
                "reply_markup" => json_encode([
                    "inline_keyboard" => [
                        [["text" => "🔍 Search Song", "callback_data" => "search_song"]],
                        [["text" => "⬇️ Download from Link", "callback_data" => "download_link"]]
                    ]
                ])
            ]);
        } else {
            apiRequest("sendMessage", [
                "chat_id" => $chatId,
                "text" => "❌ You must join both channels first."
            ]);
        }
    }

    if ($data == "search_song") {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => "🔍 Send me a song name to search on Spotify."
        ]);
    }

    if ($data == "download_link") {
        apiRequest("sendMessage", [
            "chat_id" => $chatId,
            "text" => "⬇️ Send me a full Spotify track link (example: https://open.spotify.com/track/XXXX)."
        ]);
    }

    if (strpos($data, "dl|") === 0) {
        $trackUrl = substr($data, 3);
        $info = spotifyDownload($trackUrl);

        if ($info) {
            apiRequest("sendAudio", [
                "chat_id" => $chatId,
                "audio" => $info["download"],
                "title" => $info["title"],
                "performer" => $info["artist"],
                "thumb" => $info["image"],
                "caption" => "🎵 " . $info["title"] . "\n👤 " . $info["artist"]
            ]);
        } else {
            apiRequest("sendMessage", [
                "chat_id" => $chatId,
                "text" => "❌ Could not fetch download link."
            ]);
        }
    }
}
?>
